// CXact_OLTP_Write.cpp

#include "stdafx.h"
#include "PCMAG_ORA8.h"
#include "PCMag_OLTP_Write.h"

// IMPLEMENT_SERIAL macro calls
IMPLEMENT_SERIAL(CXact_OLTP_Write_01,CXact,1)
IMPLEMENT_SERIAL(CXact_OLTP_Write_02,CXact,1)
IMPLEMENT_SERIAL(CXact_OLTP_Write_03,CXact,1)
IMPLEMENT_SERIAL(CXact_OLTP_Write_04,CXact,1)
IMPLEMENT_SERIAL(CXact_OLTP_Write_05,CXact,1)

// ================================================================================

// CXact_OLTP_Write_01

CXact_OLTP_Write_01::CXact_OLTP_Write_01 (void)
{
	m_szName		= "OLTP Write 01";
	m_szDescription = "begin oltp_write.oltp_write_01 (:randbase); end;";
	m_szSQL			= "begin oltp_write.oltp_write_01 (:randbase); end;";
	m_nXactType		= randomTRANSACTION;
	m_nXID			= XID_OLTP_WRITE+01;
	m_nGID			= OLTPWrite;
}

CXact_OLTP_Write_01::~CXact_OLTP_Write_01 (void)
{
}

BOOL CXact_OLTP_Write_01::PreBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogon ();
	#endif
	return TRUE;
}

BOOL CXact_OLTP_Write_01::PostBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogoff ();
	#endif
	return TRUE;
}

BOOL CXact_OLTP_Write_01::Execute (void)
{
	
	// declare variables
	COracle8Driver *pSQLDatabaseServer;
	OCIEnv* pEnvironment;
	OCIError* pError;
	OCISvcCtx* pServerContext;
	sword ReturnCode;
	sword ExecuteReturnCode;
	unsigned long randbase;
	OCIStmt* pStmt;
	OCIBind *pBind;

	// initialize variables
	pBind = (OCIBind *)NULL;
	#if (_NOBF_ORA8_ == FALSE)
		pSQLDatabaseServer = (COracle8Driver*) m_pCSQLObject;
	#endif
	pEnvironment = pSQLDatabaseServer->GetOCIEnvironment();
	pError = pSQLDatabaseServer->GetOCIError();
	pServerContext = pSQLDatabaseServer->GetOCIServerContext();

	// allocate a statement handle
	ReturnCode = OCIHandleAlloc (pEnvironment, (dvoid**)&pStmt, OCI_HTYPE_STMT, (size_t)0, (dvoid**)NULL);
	CHECK_FOR_ERROR;
	
	// prepare the statement
	ReturnCode = OCIStmtPrepare (pStmt, pError, (UCHAR *)m_szSQL.GetBuffer(0), m_szSQL.GetLength(), OCI_NTV_SYNTAX, OCI_DEFAULT);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR;
	
	// bind input variables
	ReturnCode = OCIBindByName (pStmt, &pBind, pError, (text *) ":randbase", -1, (dvoid *)&randbase, (sword)sizeof(randbase), SQLT_INT, (dvoid *)NULL, (ub2 *)0, (ub2 *)0, (ub4) 0, (ub4 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	
	// set statement attributes
	ReturnCode = OCIAttrSet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&NUM_ROWS, (ub4)sizeof(NUM_ROWS), OCI_ATTR_PREFETCH_ROWS, pError);
	CHECK_FOR_ERROR;

	// ==========
	
	// initialize variables
	randbase = (long) m_CRandom.GetRandom(2,990000);	// lowered from 1,000,000 to prevent referential integrity failures

	// start timer
	m_CTimer.SetStartTime();

	// execute the statement
	ExecuteReturnCode = OCIStmtExecute (pServerContext, pStmt, pError, NUM_ROWS, (ub4) 0, (OCISnapshot *) NULL, (OCISnapshot *) NULL, OCI_DEFAULT);
	CHECK_FOR_ERROR_EXECUTE;

	// stored procedure has been run, record response time
	m_CTimer.SetResponseTime();

	// update statistics
	m_nTotalRows = 0;
	m_nTotalBytes = 0;

	// set end time
	m_CTimer.SetEndTime (m_nTotalRows, m_nTotalBytes);

	// free handle
	ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
	CHECK_FOR_ERROR;

	// return
	return TRUE;

}

// ================================================================================

// CXact_OLTP_Write_02

CXact_OLTP_Write_02::CXact_OLTP_Write_02 (void)
{
	m_szName		= "OLTP Write 02";
	m_szDescription = "begin oltp_write.oltp_write_02 (:randbase); end;";
	m_szSQL			= "begin oltp_write.oltp_write_02 (:randbase); end;";
	m_nXactType		= randomTRANSACTION;
	m_nXID			= XID_OLTP_WRITE+02;
	m_nGID			= OLTPWrite;
}

CXact_OLTP_Write_02::~CXact_OLTP_Write_02 (void)
{
}

BOOL CXact_OLTP_Write_02::PreBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogon ();
	#endif
	return TRUE;
}

BOOL CXact_OLTP_Write_02::PostBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogoff ();
	#endif
	return TRUE;
}

BOOL CXact_OLTP_Write_02::Execute (void)
{
	
	// declare variables
	COracle8Driver *pSQLDatabaseServer;
	OCIEnv* pEnvironment;
	OCIError* pError;
	OCISvcCtx* pServerContext;
	sword ReturnCode;
	sword ExecuteReturnCode;
	unsigned long randbase;
	OCIStmt* pStmt;
	OCIBind *pBind;

	// initialize variables
	pBind = (OCIBind *)NULL;
	#if (_NOBF_ORA8_ == FALSE)
		pSQLDatabaseServer = (COracle8Driver*) m_pCSQLObject;
	#endif
	pEnvironment = pSQLDatabaseServer->GetOCIEnvironment();
	pError = pSQLDatabaseServer->GetOCIError();
	pServerContext = pSQLDatabaseServer->GetOCIServerContext();

	// allocate a statement handle
	ReturnCode = OCIHandleAlloc (pEnvironment, (dvoid**)&pStmt, OCI_HTYPE_STMT, (size_t)0, (dvoid**)NULL);
	CHECK_FOR_ERROR;
	
	// prepare the statement
	ReturnCode = OCIStmtPrepare (pStmt, pError, (UCHAR *)m_szSQL.GetBuffer(0), m_szSQL.GetLength(), OCI_NTV_SYNTAX, OCI_DEFAULT);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR;
	
	// bind input variables
	ReturnCode = OCIBindByName (pStmt, &pBind, pError, (text *) ":randbase", -1, (dvoid *)&randbase, (sword)sizeof(randbase), SQLT_INT, (dvoid *)NULL, (ub2 *)0, (ub2 *)0, (ub4) 0, (ub4 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	
	// set statement attributes
	ReturnCode = OCIAttrSet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&NUM_ROWS, (ub4)sizeof(NUM_ROWS), OCI_ATTR_PREFETCH_ROWS, pError);
	CHECK_FOR_ERROR;

	// ==========

	// initialize variables
	randbase = (long) m_CRandom.GetRandom(2,1000000);

	// start timer
	m_CTimer.SetStartTime();

	// execute the statement
	ExecuteReturnCode = OCIStmtExecute (pServerContext, pStmt, pError, NUM_ROWS, (ub4) 0, (OCISnapshot *) NULL, (OCISnapshot *) NULL, OCI_DEFAULT);
	CHECK_FOR_ERROR_EXECUTE;

	// stored procedure has been run, record response time
	m_CTimer.SetResponseTime();

	// update statistics
	m_nTotalRows = 0;
	m_nTotalBytes = 0;

	// set end time
	m_CTimer.SetEndTime (m_nTotalRows, m_nTotalBytes);

	// free handle
	ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
	CHECK_FOR_ERROR;

	// return
	return TRUE;

}

// ================================================================================

// CXact_OLTP_Write_03

CXact_OLTP_Write_03::CXact_OLTP_Write_03 (void)
{
	m_szName		= "OLTP Write 03";
	m_szDescription = "begin oltp_write.oltp_write_03 (:randfivemill); end;";
	m_szSQL			= "begin oltp_write.oltp_write_03 (:randfivemill); end;";
	m_nXactType		= randomTRANSACTION;
	m_nXID			= XID_OLTP_WRITE+03;
	m_nGID			= OLTPWrite;
}

CXact_OLTP_Write_03::~CXact_OLTP_Write_03 (void)
{
}

BOOL CXact_OLTP_Write_03::PreBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogon ();
	#endif
	return TRUE;
}

BOOL CXact_OLTP_Write_03::PostBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogoff ();
	#endif
	return TRUE;
}

BOOL CXact_OLTP_Write_03::Execute (void)
{
	
	// declare variables
	COracle8Driver *pSQLDatabaseServer;
	OCIEnv* pEnvironment;
	OCIError* pError;
	OCISvcCtx* pServerContext;
	sword ReturnCode;
	sword ExecuteReturnCode;
	unsigned long randfivemill;
	OCIStmt* pStmt;
	OCIBind *pBind;

	// initialize variables
	pBind = (OCIBind *)NULL;
	#if (_NOBF_ORA8_ == FALSE)
		pSQLDatabaseServer = (COracle8Driver*) m_pCSQLObject;
	#endif
	pEnvironment = pSQLDatabaseServer->GetOCIEnvironment();
	pError = pSQLDatabaseServer->GetOCIError();
	pServerContext = pSQLDatabaseServer->GetOCIServerContext();

	// allocate a statement handle
	ReturnCode = OCIHandleAlloc (pEnvironment, (dvoid**)&pStmt, OCI_HTYPE_STMT, (size_t)0, (dvoid**)NULL);
	CHECK_FOR_ERROR;
	
	// prepare the statement
	ReturnCode = OCIStmtPrepare (pStmt, pError, (UCHAR *)m_szSQL.GetBuffer(0), m_szSQL.GetLength(), OCI_NTV_SYNTAX, OCI_DEFAULT);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR;
	
	// bind input variables
	ReturnCode = OCIBindByName (pStmt, &pBind, pError, (text *) ":randfivemill", -1, (dvoid *)&randfivemill, (sword)sizeof(randfivemill), SQLT_INT, (dvoid *)NULL, (ub2 *)0, (ub2 *)0, (ub4) 0, (ub4 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	
	// set statement attributes
	ReturnCode = OCIAttrSet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&NUM_ROWS, (ub4)sizeof(NUM_ROWS), OCI_ATTR_PREFETCH_ROWS, pError);
	CHECK_FOR_ERROR;

	// ==========
	
	// initialize variables
	randfivemill = (long) m_CRandom.GetRandom(2,5000000);

	// start timer
	m_CTimer.SetStartTime();

	// execute the statement
	ExecuteReturnCode = OCIStmtExecute (pServerContext, pStmt, pError, NUM_ROWS, (ub4) 0, (OCISnapshot *) NULL, (OCISnapshot *) NULL, OCI_DEFAULT);
	CHECK_FOR_ERROR_EXECUTE;

	// stored procedure has been run, record response time
	m_CTimer.SetResponseTime();

	// update statistics
	m_nTotalRows = 0;
	m_nTotalBytes = 0;

	// set end time
	m_CTimer.SetEndTime (m_nTotalRows, m_nTotalBytes);

	// free handle
	ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
	CHECK_FOR_ERROR;

	// return
	return TRUE;

}

// ================================================================================

// CXact_OLTP_Write_04

CXact_OLTP_Write_04::CXact_OLTP_Write_04 (void)
{
	m_szName		= "OLTP Write 04";
	m_szDescription = "begin oltp_write.oltp_write_04 (:randfourmill); end;";
	m_szSQL			= "begin oltp_write.oltp_write_04 (:randfourmill); end;";
	m_nXactType		= randomTRANSACTION;
	m_nXID			= XID_OLTP_WRITE+04;
	m_nGID			= OLTPWrite;
}

CXact_OLTP_Write_04::~CXact_OLTP_Write_04 (void)
{
}

BOOL CXact_OLTP_Write_04::PreBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogon ();
	#endif
	return TRUE;
}

BOOL CXact_OLTP_Write_04::PostBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogoff ();
	#endif
	return TRUE;
}

BOOL CXact_OLTP_Write_04::Execute (void)
{
	
	// declare variables
	COracle8Driver *pSQLDatabaseServer;
	OCIEnv* pEnvironment;
	OCIError* pError;
	OCISvcCtx* pServerContext;
	sword ReturnCode;
	sword ExecuteReturnCode;
	unsigned long randfourmill;
	OCIStmt* pStmt;
	OCIBind *pBind;

	// initialize variables
	pBind = (OCIBind *)NULL;
	#if (_NOBF_ORA8_ == FALSE)
		pSQLDatabaseServer = (COracle8Driver*) m_pCSQLObject;
	#endif
	pEnvironment = pSQLDatabaseServer->GetOCIEnvironment();
	pError = pSQLDatabaseServer->GetOCIError();
	pServerContext = pSQLDatabaseServer->GetOCIServerContext();

	// allocate a statement handle
	ReturnCode = OCIHandleAlloc (pEnvironment, (dvoid**)&pStmt, OCI_HTYPE_STMT, (size_t)0, (dvoid**)NULL);
	CHECK_FOR_ERROR;
	
	// prepare the statement
	ReturnCode = OCIStmtPrepare (pStmt, pError, (UCHAR *)m_szSQL.GetBuffer(0), m_szSQL.GetLength(), OCI_NTV_SYNTAX, OCI_DEFAULT);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR;
	
	// bind input variables
	ReturnCode = OCIBindByName (pStmt, &pBind, pError, (text *) ":randfourmill", -1, (dvoid *)&randfourmill, (sword)sizeof(randfourmill), SQLT_INT, (dvoid *)NULL, (ub2 *)0, (ub2 *)0, (ub4) 0, (ub4 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	
	// set statement attributes
	ReturnCode = OCIAttrSet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&NUM_ROWS, (ub4)sizeof(NUM_ROWS), OCI_ATTR_PREFETCH_ROWS, pError);
	CHECK_FOR_ERROR;

	// ==========
	
	// initialize variables
	randfourmill = (long) m_CRandom.GetRandom(2,4000000);

	// start timer
	m_CTimer.SetStartTime();

	// execute the statement
	ExecuteReturnCode = OCIStmtExecute (pServerContext, pStmt, pError, NUM_ROWS, (ub4) 0, (OCISnapshot *) NULL, (OCISnapshot *) NULL, OCI_DEFAULT);
	CHECK_FOR_ERROR_EXECUTE;

	// stored procedure has been run, record response time
	m_CTimer.SetResponseTime();

	// update statistics
	m_nTotalRows = 0;
	m_nTotalBytes = 0;

	// set end time
	m_CTimer.SetEndTime (m_nTotalRows, m_nTotalBytes);

	// free handle
	ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
	CHECK_FOR_ERROR;

	// return
	return TRUE;

}

// ================================================================================

// CXact_OLTP_Write_05

CXact_OLTP_Write_05::CXact_OLTP_Write_05 (void)
{
	m_szName		= "OLTP Write 05";
	m_szDescription = "begin oltp_write.oltp_write_05 (:randbase); end;";
	m_szSQL			= "begin oltp_write.oltp_write_05 (:randbase); end;";
	m_nXactType		= randomTRANSACTION;
	m_nXID			= XID_OLTP_WRITE+05;
	m_nGID			= OLTPWrite;
}

CXact_OLTP_Write_05::~CXact_OLTP_Write_05 (void)
{
}

BOOL CXact_OLTP_Write_05::PreBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogon ();
	#endif
	return TRUE;
}

BOOL CXact_OLTP_Write_05::PostBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogoff ();
	#endif
	return TRUE;
}

BOOL CXact_OLTP_Write_05::Execute (void)
{
	
	// declare variables
	COracle8Driver *pSQLDatabaseServer;
	OCIEnv* pEnvironment;
	OCIError* pError;
	OCISvcCtx* pServerContext;
	sword ReturnCode;
	sword ExecuteReturnCode;
	unsigned long randbase;
	OCIStmt* pStmt;
	OCIBind *pBind;

	// initialize variables
	pBind = (OCIBind *)NULL;
	#if (_NOBF_ORA8_ == FALSE)
		pSQLDatabaseServer = (COracle8Driver*) m_pCSQLObject;
	#endif
	pEnvironment = pSQLDatabaseServer->GetOCIEnvironment();
	pError = pSQLDatabaseServer->GetOCIError();
	pServerContext = pSQLDatabaseServer->GetOCIServerContext();

	// allocate a statement handle
	ReturnCode = OCIHandleAlloc (pEnvironment, (dvoid**)&pStmt, OCI_HTYPE_STMT, (size_t)0, (dvoid**)NULL);
	CHECK_FOR_ERROR;
	
	// prepare the statement
	ReturnCode = OCIStmtPrepare (pStmt, pError, (UCHAR *)m_szSQL.GetBuffer(0), m_szSQL.GetLength(), OCI_NTV_SYNTAX, OCI_DEFAULT);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR;
	
	// bind input variables
	ReturnCode = OCIBindByName (pStmt, &pBind, pError, (text *) ":randbase", -1, (dvoid *)&randbase, (sword)sizeof(randbase), SQLT_INT, (dvoid *)NULL, (ub2 *)0, (ub2 *)0, (ub4) 0, (ub4 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	
	// set statement attributes
	ReturnCode = OCIAttrSet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&NUM_ROWS, (ub4)sizeof(NUM_ROWS), OCI_ATTR_PREFETCH_ROWS, pError);
	CHECK_FOR_ERROR;

	// ==========

	// initialize variables
	randbase = (long) m_CRandom.GetRandom(2,1000000);

	// start timer
	m_CTimer.SetStartTime();

	// execute the statement
	ExecuteReturnCode = OCIStmtExecute (pServerContext, pStmt, pError, NUM_ROWS, (ub4) 0, (OCISnapshot *) NULL, (OCISnapshot *) NULL, OCI_DEFAULT);
	CHECK_FOR_ERROR_EXECUTE;

	// stored procedure has been run, record response time
	m_CTimer.SetResponseTime();

	// update statistics
	m_nTotalRows = 0;
	m_nTotalBytes = 0;

	// set end time
	m_CTimer.SetEndTime (m_nTotalRows, m_nTotalBytes);

	// free handle
	ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
	CHECK_FOR_ERROR;

	// return
	return TRUE;

}
